﻿using PpmsDataWebService.Models;
using PpmsDataWebService.Mappers;
using VA.PPMS.Context;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Threading.Tasks;
using System.Web;
using System.Web.Http;
using Microsoft.AspNet.OData;
using Microsoft.AspNet.OData.Routing;
using System.Web.Http.Description;
using Microsoft.Web.Http;
using Microsoft.Xrm.Sdk.Query;
using Microsoft.Xrm.Sdk;

namespace PpmsDataWebService.Controllers
{

    //[Authorize]
    [EnableQuery]
    [ApiVersion("1.0")]
    public class CareSitesController : ODataController
    {
        [ODataRoute("CareSites({Name})")]
        public async Task<HttpResponseMessage> Get([FromODataUri] string Name)
        {
            //We will use the Query type found in URL to determine if Expanded properties need to be mapped. 
            var queryType = HttpContext.Current.Request.Url.Query;


            //This Scenario find's the first care Site matching on the name.  
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Retrieve the care Site Record
                var ppmsCareSite = context.ppms_caresiteSet.FirstOrDefault(i => i.ppms_name.Contains(Name));
                if (ppmsCareSite != null)
                {
                    var ppmsCareSitesList = new List<ppms_caresite> { ppmsCareSite };
                    var careSites = await CareSiteMap.MapCareSites(ppmsCareSitesList, queryType, context);
                    return Request.CreateResponse(careSites);

                }
            }
            var message = string.Format("Care Site with Name: {0} not found", Name);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("CareSites({Name})/OwningOrganization")]
        public async Task<HttpResponseMessage> GetOwningOrganization([FromODataUri] string Name)
        {

            //This Scenario find's the first care Site matching on the name.  
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsCareSite = context.ppms_caresiteSet.FirstOrDefault(i => i.ppms_name.Contains(Name));
                if (ppmsCareSite != null)
                {
                    //Retrieve the related Owning Organization
                    var ppmsOwningOrg =
                        context.AccountSet.FirstOrDefault(i => i.Id == ppmsCareSite.ppms_organization.Id);
                    var ppmsOwningOrgList = new List<Account> { ppmsOwningOrg };
                    var owningOrganization =
                        await ProviderMap.MapProviders(ppmsOwningOrgList, "None");
                    return Request.CreateResponse(owningOrganization);
                }
            }
            var message = string.Format("Owning Organizatino with Care Site Name: {0} not found", Name);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("CareSites({Name})/Providers")]
        public async Task<HttpResponseMessage> GetProviders([FromODataUri] string Name)
        {

            //This Scenario find's the first care Site matching on the name.  
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsCareSite = context.ppms_caresiteSet.FirstOrDefault(i => i.ppms_name.Contains(Name));
                if (ppmsCareSite != null)
                {
                    //Retrieve the related Providers
                    var ppmsProviders =
                        context.AccountSet.Where(i => i.ppms_ownedcaresite.Id == ppmsCareSite.Id);
                    var ppmsProvidersList = ppmsProviders.ToList();
                    var providers =
                        await ProviderMap.MapProviders(ppmsProvidersList, "None");
                    return Request.CreateResponse(providers);

                }
            }
            var message = string.Format("Providers with Care Site Name: {0} not found", Name);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("CareSites({Name})/ProviderServices")]
        public async Task<HttpResponseMessage> GetRelatedProviderServices([FromODataUri] string Name)
        {

            //This Scenario find's the first care Site matching on the name.  
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsCareSite = context.ppms_caresiteSet.FirstOrDefault(i => i.ppms_name.Contains(Name));
                if (ppmsCareSite != null)
                {
                    //Retrieve the related Provider Services
                    var ppmsProviderServices =
                        context.ppms_providerserviceSet.Where(i => i.ppms_caresite.Id == ppmsCareSite.Id);
                    var ppmsProviderServicesList = ppmsProviderServices.ToList();
                    var providerServices =
                        await ProviderServicesMap.MapProviderServices(ppmsProviderServicesList, "None", context);
                    return Request.CreateResponse(providerServices);
                }
            }
            var message = string.Format("Provider Services with Care Site Name: {0} not found", Name);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("CareSites({Name})/ProviderPrivileges")]
        public async Task<HttpResponseMessage> GetProviderPrivileges([FromODataUri] string Name)
        {

            //This Scenario find's the first care Site matching on the name.  
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsCareSite = context.ppms_caresiteSet.FirstOrDefault(i => i.ppms_name.Contains(Name));
                if (ppmsCareSite != null)
                {
                    //Retrieve the related Provider Privileges 
                    var ppmsProviderPrivileges =
                        context.ppms_providerprivilegeSet.Where(i => i.ppms_CareSite.Id == ppmsCareSite.Id);
                    var ppmsProviderPrivilegesList = ppmsProviderPrivileges.ToList();
                    var providerPrivileges =
                        await ProviderPrivilegesMap.MapProviderPrivileges(ppmsProviderPrivilegesList, "None", context);
                    return Request.CreateResponse(providerPrivileges);
                }
            }
            var message = string.Format("Provider Privileges with Care Site Name: {0} not found", Name);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("CareSites({Name})/VaProviderRelationships")]
        public async Task<HttpResponseMessage> GetCareSiteVaProviderRelationships([FromODataUri] string Name)
        {

            //This Scenario find's the first care Site matching on the name.  
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsCareSite = context.ppms_caresiteSet.FirstOrDefault(i => i.ppms_name.Contains(Name));
                if (ppmsCareSite != null)
                {
                    var ppmsVaProviderRelationships = context.ppms_vaproviderrelationshipSet.Where(i => i.ppms_CareSiteId.Id == ppmsCareSite.Id);
                    var ppmsVaProviderRelationshipsList = ppmsVaProviderRelationships.ToList();
                    if (ppmsVaProviderRelationshipsList.Any())
                    {
                        //Map Va Provider Relationships
                        var vaProviderRelationships = await VaProviderRelationshipMap.MapVaProviderRelationships(ppmsVaProviderRelationshipsList, "None", context);
                        return Request.CreateResponse(vaProviderRelationships);
                    }
                }
            }
            var message = string.Format("Provider Privileges with Care Site Name: {0} not found", Name);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        
        [ODataRoute("CareSites({Name})/PlaceOfServiceCodes")]
        public async Task<HttpResponseMessage> GetCareSitePlaceOfServiceCodes([FromODataUri] string Name)
        {

            var _service = await PpmsContextHelper.GetProxy();
            //This Scenario find's the first care Site matching on the name.  
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsCareSite = context.ppms_caresiteSet.FirstOrDefault(i => i.ppms_name.Contains(Name));
                if (ppmsCareSite != null)
                {
                    QueryExpression qe = new QueryExpression();
                    qe.EntityName = ppms_providerplaceofservice.EntityLogicalName;
                    qe.ColumnSet = new ColumnSet();
                    qe.ColumnSet.AllColumns = true;

                    //Initialize Filter Expression for Provider
                    var filterExpression = new FilterExpression();
                    filterExpression.FilterOperator = LogicalOperator.And;
                    var condition = new ConditionExpression("statuscode", ConditionOperator.Equal, ((int)ppms_providerplaceofservice_StatusCode.Active).ToString());
                    filterExpression.AddCondition(condition);
                    var condition2 = new ConditionExpression("ppms_caresiteid", ConditionOperator.Equal, ppmsCareSite.Id);
                    filterExpression.AddCondition(condition2);
                    qe.Criteria.AddFilter(filterExpression);

                    var linkedEntity = new LinkEntity
                    {
                        JoinOperator = JoinOperator.Inner,
                        LinkFromAttributeName = "ppms_placeofservicecodeid",
                        LinkFromEntityName = ppms_providerplaceofservice.EntityLogicalName,
                        LinkToAttributeName = "ppms_placeofservicecodeid",
                        LinkToEntityName = ppms_placeofservicecode.EntityLogicalName,
                       
                    };
                    linkedEntity.Columns.AddColumns("ppms_name", "ppms_placeofservicecode", "ppms_placeofservicedescription");
                    linkedEntity.EntityAlias = "placeofservicecode";

                    qe.LinkEntities.Add(linkedEntity);

                    var placeOfServiceList = new List<ppms_providerplaceofservice>();
                    EntityCollection ec = _service.RetrieveMultiple(qe);

                    if (ec.Entities != null)
                    {
                        //Add to the Provider list
                        placeOfServiceList.AddRange(ec.Entities.Select(e => e.ToEntity<ppms_providerplaceofservice>()).ToList());
                    }

                    if (placeOfServiceList.Any())
                    {
                        //Map Place of Services
                        var placeOfServices = await ProviderPlaceOfServiceMap.MapProviderPlaceOfServiceCodes(placeOfServiceList);
                        return Request.CreateResponse(placeOfServices);
                    }
                }
            }
            var message = string.Format("No Provider Place of Services found for this Care Site");
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }
        

        [ODataRoute("CareSites({Name})/SiteContact")]
        public async Task<HttpResponseMessage> GetSiteContact([FromODataUri] string Name)
        {

            //This Scenario find's the first care Site matching on the name.  
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsCareSite = context.ppms_caresiteSet.FirstOrDefault(i => i.ppms_name.Contains(Name));
                if (ppmsCareSite != null)
                {
                    //Retrieve the related Site Contact
                    var ppmsSiteContact =
                        context.ContactSet.FirstOrDefault(i => i.Id == ppmsCareSite.ppms_SiteContact.Id);
                    var ppmsSiteContactList = new List<Contact> { ppmsSiteContact };
                    var siteContact =
                        await ProviderContactsMap.MapProviderContacts(ppmsSiteContactList, "None", context);
                    return Request.CreateResponse(siteContact);
                }
            }
            var message = string.Format("Site Contact with Care Site Name: {0} not found", Name);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        //[HttpGet]
        //[MapToApiVersion("1.0")]
        //[ResponseType(typeof(CareSite))]
        [ODataRoute("GetCareSiteByCity")]
        public async Task<HttpResponseMessage> GetCareSiteByCity([FromODataUri] string city)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {

                var ppmsCareSites = context.ppms_caresiteSet.Where(i => i.ppms_address_city.Contains(city));
                var ppmsCareSitesList = ppmsCareSites.ToList();
                if (ppmsCareSitesList.Any())
                {
                    //Map Care Sites
                    var careSites = await CareSiteMap.MapCareSites(ppmsCareSitesList, "None", context);
                    return Request.CreateResponse(careSites);
                }
                var message = string.Format("Care Sites with City Name: {0} not found", city);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
            }
        }

        //[HttpGet]
        //[MapToApiVersion("1.0")]
        //[ResponseType(typeof(CareSite))]
        [ODataRoute("GetCareSiteByState")]
        public async Task<HttpResponseMessage> GetCareSiteByState([FromODataUri] string state)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {

                var ppmsCareSites = context.ppms_caresiteSet.Where(i => i.ppms_statename.Contains(state));
                var ppmsCareSitesList = ppmsCareSites.ToList();
                if (ppmsCareSitesList.Any())
                {
                    //Map Care Sites
                    var careSites = await CareSiteMap.MapCareSites(ppmsCareSitesList, "None", context);
                    return Request.CreateResponse(careSites);
                }
                var message = string.Format("Care Sites with State Name: {0} not found", state);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
            }
        }

        //[HttpGet]
        //[MapToApiVersion("1.0")]
        //[ResponseType(typeof(CareSite))]
        [ODataRoute("GetCareSiteByZip")]
        public async Task<HttpResponseMessage> GetCareSiteByZip([FromODataUri] string zip)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsCareSites = context.ppms_caresiteSet.Where(i => i.ppms_address_postalcode.Contains(zip));
                var ppmsCareSitesList = ppmsCareSites.ToList();
                if (ppmsCareSitesList.Any())
                {
                    //Map Care Sites
                    var careSites = await CareSiteMap.MapCareSites(ppmsCareSitesList, "None", context);
                    return Request.CreateResponse(careSites);
                }
                var message = string.Format("Care Sites with Zip Code: {0} not found", zip);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
            }
        }

        [ODataRoute("GetCareSiteByNameAddress")]
        public async Task<HttpResponseMessage> GetCareSiteByNameAddress([FromODataUri] string name, [FromODataUri] string address)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {

                var ppmsCareSites = context.ppms_caresiteSet.Where(i => i.ppms_name.Contains(name) && i.ppms_address_compositeid.Contains(address));
                var ppmsCareSitesList = ppmsCareSites.ToList();
                if (ppmsCareSitesList.Any())
                {
                    //Map Care Sites
                    var careSites = await CareSiteMap.MapCareSites(ppmsCareSitesList, "None", context);
                    return Request.CreateResponse(careSites);
                }
                var message = string.Format("Care Site with matching name & address not found");
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
            }
        }



        [ODataRoute("CareSites")]
        public async Task<HttpResponseMessage> Get()
        {
            //This Scenario returns the first 50 Care Sites
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsCareSites = context.ppms_caresiteSet.Where(i => i.ppms_name != null).Take(50);
                var ppmsCareSitesList = ppmsCareSites.ToList();
                if (ppmsCareSitesList.Any())
                {
                    //Map Care Sites
                    var careSites = await CareSiteMap.MapCareSites(ppmsCareSitesList, "None", context);
                    return Request.CreateResponse(careSites);
                }
                var message = string.Format("Care Sites not found");
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }
    }
}